/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import jclass.chart.ChartCanvas;
import jclass.chart.ChartText;

public class JCTitle
extends ChartCanvas {
    ChartText label;

    public JCTitle() {
        this.isShowing = false;
        this.label = new ChartText();
        this.label.setParent(this);
    }

    public ChartText getLabel() {
        return this.label;
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String string) {
        this.label.setText(string, true);
    }

    public int getAdjust() {
        return this.label.getAdjust();
    }

    public synchronized void setAdjust(int n) {
        this.label.setAdjust(n);
    }

    public void paintComponent(Graphics graphics) {
        if (!this.isShowing) {
            return;
        }
        Graphics graphics2 = graphics.create();
        super.paintComponent(graphics2);
        this.label.draw(graphics2);
        if (graphics2 != null) {
            graphics2.dispose();
        }
    }

    public boolean getChanged() {
        return this.changed || this.label.getChanged();
    }

    public void setChanged(boolean bl) {
        this.label.setChanged(bl, false);
        super.setChanged(bl);
    }

    public void setChanged(boolean bl, boolean bl2) {
        if (bl2) {
            this.setChanged(bl);
            return;
        }
        this.label.setChanged(bl, false);
        this.changed = bl;
    }

    public void recalc() {
        if (!this.isChanged()) {
            return;
        }
        super.preferredSize();
        if (!this.isShowing) {
            this.setChanged(false);
            return;
        }
        int n = this.getHighlightThickness() + this.getShadowThickness();
        Insets insets = this.getInsets();
        this.label.recalc();
        if (!this.cc_width.isDefault) {
            this.ps.width = this.cc_width.value;
        } else {
            this.ps.width = this.label.getWidth();
            this.ps.width += 2 * n + insets.left + insets.right;
        }
        if (!this.cc_height.isDefault) {
            this.ps.height = this.cc_height.value;
        } else {
            this.ps.height = this.label.getHeight();
            this.ps.height += 2 * n + insets.top + insets.bottom;
        }
        this.label.reshape(0, 0, this.ps.width - 2 * n - insets.left - insets.right, this.ps.height - 2 * n - insets.top - insets.bottom);
        this.resize(this.ps.width, this.ps.height);
        this.setChanged(false);
        this.needsRepaint = true;
    }

    public Dimension preferredSize() {
        this.recalc();
        return new Dimension(this.ps);
    }
}

